/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.bpmengine;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.router.Route;
import io.flowset.control.action.TestEngineConnectionAction;
import io.flowset.control.entity.engine.AuthType;
import io.flowset.control.entity.engine.BpmEngine;
import io.flowset.control.entity.engine.EngineType;
import io.flowset.control.service.engine.EngineService;
import io.flowset.control.view.bpmengine.BasicAuthFragment;
import io.flowset.control.view.bpmengine.BpmEngineDetailView;
import io.flowset.control.view.bpmengine.HttpHeaderAuthFragment;
import io.flowset.control.view.main.MainView;
import io.jmix.core.EntityStates;
import io.jmix.core.SaveContext;
import io.jmix.flowui.Fragments;
import io.jmix.flowui.component.SupportsTypedValue;
import io.jmix.flowui.component.checkbox.JmixCheckbox;
import io.jmix.flowui.component.radiobuttongroup.JmixRadioButtonGroup;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentOwner;
import io.jmix.flowui.view.EditedEntityContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardDetailView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;

@Route(value="bpm/engines/:id", layout=MainView.class)
@ViewController(id="BpmEngine.detail")
@ViewDescriptor(path="bpm-engine-detail-view.xml")
@EditedEntityContainer(value="bpmEngineDc")
public class BpmEngineDetailView
extends StandardDetailView<BpmEngine> {
    protected static final Logger log = LoggerFactory.getLogger(BpmEngineDetailView.class);
    @Autowired
    protected Fragments fragments;
    @Autowired
    protected EngineService engineService;
    @Autowired
    protected EntityStates entityStates;
    @Autowired
    protected BuildProperties buildProperties;
    @ViewComponent
    protected MessageBundle messageBundle;
    @ViewComponent
    protected Div authBox;
    @ViewComponent
    protected JmixRadioButtonGroup<AuthType> authTypeGroup;
    @ViewComponent
    protected JmixCheckbox defaultField;
    @ViewComponent
    protected TestEngineConnectionAction testConnectionAction;
    @ViewComponent
    protected TypedTextField<String> baseUrlField;

    @Subscribe
    public void onInitEntity(StandardDetailView.InitEntityEvent<BpmEngine> event) {
        BpmEngine entity = (BpmEngine)event.getEntity();
        entity.setType(EngineType.CAMUNDA_7);
        boolean engineExists = this.engineService.engineExists();
        if (!engineExists) {
            entity.setIsDefault(Boolean.valueOf(true));
        }
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        String buildType;
        BpmEngine engine = (BpmEngine)this.getEditedEntity();
        this.testConnectionAction.setEngine(engine);
        this.initAuthBox(engine.getAuthEnabled());
        if (BooleanUtils.isTrue((Boolean)engine.getIsDefault()) && !this.entityStates.isNew((Object)engine)) {
            this.defaultField.setEnabled(false);
        }
        String hostExample = StringUtils.equals((CharSequence)(buildType = this.buildProperties.get("buildType")), (CharSequence)"docker") ? "http://host.docker.internal:8080/engine-rest" : "http://localhost:8080/engine-rest";
        this.baseUrlField.setHelperText(this.messageBundle.formatMessage("baseUrlField.helperText", new Object[]{hostExample}));
    }

    public String getPageTitle() {
        BpmEngine engine = (BpmEngine)this.getEditedEntityOrNull();
        if (engine == null) {
            return this.messageBundle.getMessage("bpmEngineDetailView.title");
        }
        return this.entityStates.isNew((Object)engine) ? this.messageBundle.getMessage("newBpmEngineDetailView.title") : this.messageBundle.formatMessage("existingBpmEngineDetailView.title", new Object[]{engine.getName()});
    }

    @Install(target=Target.DATA_CONTEXT)
    protected Set<Object> saveDelegate(SaveContext saveContext) {
        BpmEngine engineToSave = (BpmEngine)saveContext.getEntitiesToSave().get(BpmEngine.class, (Object)((BpmEngine)this.getEditedEntity()).getId());
        Set entities = this.engineService.saveEngine(engineToSave);
        return entities;
    }

    @Subscribe(value="authEnabledField")
    public void onAuthEnabledFieldComponentValueChange(AbstractField.ComponentValueChangeEvent<JmixCheckbox, Boolean> event) {
        Boolean isEnabled = (Boolean)event.getValue();
        this.initAuthBox(isEnabled);
    }

    protected void initAuthBox(Boolean isEnabled) {
        this.authBox.setEnabled(isEnabled.booleanValue());
        this.authTypeGroup.setEnabled(isEnabled.booleanValue());
        if (BooleanUtils.isNotTrue((Boolean)isEnabled)) {
            ((BpmEngine)this.getEditedEntity()).setAuthType(null);
            ((BpmEngine)this.getEditedEntity()).setBasicAuthUsername(null);
            ((BpmEngine)this.getEditedEntity()).setBasicAuthPassword(null);
            ((BpmEngine)this.getEditedEntity()).setHttpHeaderName(null);
            ((BpmEngine)this.getEditedEntity()).setHttpHeaderValue(null);
        }
    }

    @Subscribe(value="authTypeGroup")
    public void onAuthTypeGroupComponentValueChange(AbstractField.ComponentValueChangeEvent<JmixRadioButtonGroup<AuthType>, AuthType> event) {
        AuthType type = (AuthType)event.getValue();
        Fragment authFragment = null;
        if (type != null) {
            switch (1.$SwitchMap$io$flowset$control$entity$engine$AuthType[type.ordinal()]) {
                case 1: {
                    authFragment = this.fragments.create((FragmentOwner)this, BasicAuthFragment.class);
                    break;
                }
                case 2: {
                    authFragment = this.fragments.create((FragmentOwner)this, HttpHeaderAuthFragment.class);
                    break;
                }
                default: {
                    authFragment = null;
                }
            }
        }
        this.authBox.removeAll();
        if (authFragment != null) {
            this.authBox.add(new Component[]{authFragment});
        }
    }

    @Subscribe(value="baseUrlField")
    public void onBaseUrlFieldTypedValueChange(SupportsTypedValue.TypedValueChangeEvent<TypedTextField<String>, String> event) {
        if (event.isFromClient()) {
            String trimmedValue = StringUtils.trim((String)((String)event.getValue()));
            ((BpmEngine)this.getEditedEntity()).setBaseUrl(trimmedValue);
        }
    }
}

