/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.util;

import io.flowset.control.entity.filter.DecisionDefinitionFilter;
import io.flowset.control.entity.filter.DecisionInstanceFilter;
import io.flowset.control.entity.filter.DeploymentFilter;
import io.flowset.control.entity.filter.ProcessDefinitionFilter;
import io.flowset.control.entity.filter.ProcessInstanceFilter;
import io.flowset.control.entity.processdefinition.ProcessDefinitionState;
import io.jmix.core.Sort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.community.rest.client.model.HistoricProcessInstanceQueryDto;
import org.camunda.community.rest.client.model.HistoricProcessInstanceQueryDtoSortingInner;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class QueryUtils {
    public static final String INSTANCE_ID = "id";
    public static final String PROCESS_DEFINITION_ID = "processDefinitionId";
    public static final String PROCESS_DEFINITION_KEY = "processDefinitionKey";
    public static final String BUSINESS_KEY = "businessKey";
    public static final String START_TIME = "startTime";
    public static final String END_TIME = "endTime";

    public static void addRuntimeFilters(ProcessInstanceQuery processInstanceQuery, @Nullable ProcessInstanceFilter filter) {
        if (filter == null) {
            return;
        }
        QueryUtils.addIfNotNull((Object)filter.getProcessInstanceIds(), (T instanceIds) -> processInstanceQuery.processInstanceIds(new HashSet(instanceIds)));
        QueryUtils.addIfStringNotEmpty((String)filter.getProcessDefinitionId(), arg_0 -> ((ProcessInstanceQuery)processInstanceQuery).processDefinitionId(arg_0));
        QueryUtils.addIfStringNotEmpty((String)filter.getProcessDefinitionKey(), arg_0 -> ((ProcessInstanceQuery)processInstanceQuery).processDefinitionKey(arg_0));
        QueryUtils.wrapAndAddStringIfNotEmpty((String)filter.getBusinessKeyLike(), arg_0 -> ((ProcessInstanceQuery)processInstanceQuery).processInstanceBusinessKeyLike(arg_0));
        QueryUtils.addIfTrue((Boolean)filter.getActive(), () -> ((ProcessInstanceQuery)processInstanceQuery).active());
        QueryUtils.addIfTrue((Boolean)filter.getSuspended(), () -> ((ProcessInstanceQuery)processInstanceQuery).suspended());
        QueryUtils.addIfTrue((Boolean)filter.getWithIncidents(), () -> ((ProcessInstanceQuery)processInstanceQuery).withIncident());
        QueryUtils.addIfNotNull((Object)filter.getActiveActivityIdIn(), (T activityList) -> processInstanceQuery.activityIdIn(activityList.toArray(new String[0])));
    }

    public static void addRuntimeSort(ProcessInstanceQuery processInstanceQuery, @Nullable Sort sort) {
        if (sort != null) {
            for (Sort.Order order : sort.getOrders()) {
                boolean unknownValueUsed = false;
                switch (order.getProperty()) {
                    case "id": {
                        processInstanceQuery.orderByProcessInstanceId();
                        break;
                    }
                    case "processDefinitionId": {
                        processInstanceQuery.orderByProcessDefinitionId();
                        break;
                    }
                    case "processDefinitionKey": {
                        processInstanceQuery.orderByProcessDefinitionKey();
                        break;
                    }
                    case "businessKey": {
                        processInstanceQuery.orderByBusinessKey();
                        break;
                    }
                    default: {
                        unknownValueUsed = true;
                    }
                }
                QueryUtils.addSortDirection((Query)processInstanceQuery, (!unknownValueUsed ? 1 : 0) != 0, (Sort.Order)order);
            }
        }
    }

    public static void addHistoryFilters(HistoricProcessInstanceQueryDto queryDto, @Nullable ProcessInstanceFilter filter) {
        if (filter == null) {
            return;
        }
        QueryUtils.addIfNotNull((Object)filter.getProcessInstanceIds(), arg_0 -> ((HistoricProcessInstanceQueryDto)queryDto).processInstanceIds(arg_0));
        QueryUtils.addIfStringNotEmpty((String)filter.getProcessDefinitionId(), arg_0 -> ((HistoricProcessInstanceQueryDto)queryDto).processDefinitionId(arg_0));
        QueryUtils.addIfStringNotEmpty((String)filter.getProcessDefinitionKey(), arg_0 -> ((HistoricProcessInstanceQueryDto)queryDto).processDefinitionKey(arg_0));
        QueryUtils.addIfStringNotEmpty((String)filter.getProcessInstanceId(), arg_0 -> ((HistoricProcessInstanceQueryDto)queryDto).processInstanceId(arg_0));
        QueryUtils.wrapAndAddStringIfNotEmpty((String)filter.getBusinessKeyLike(), arg_0 -> ((HistoricProcessInstanceQueryDto)queryDto).processInstanceBusinessKeyLike(arg_0));
        QueryUtils.addIfTrue((Boolean)filter.getFinished(), () -> queryDto.setFinished(Boolean.valueOf(true)));
        QueryUtils.addIfTrue((Boolean)filter.getActive(), () -> queryDto.setActive(Boolean.valueOf(true)));
        QueryUtils.addIfTrue((Boolean)filter.getSuspended(), () -> queryDto.setSuspended(Boolean.valueOf(true)));
        QueryUtils.addIfTrue((Boolean)filter.getUnfinished(), () -> queryDto.setUnfinished(Boolean.valueOf(true)));
        QueryUtils.addIfTrue((Boolean)filter.getWithIncidents(), () -> {
            queryDto.withIncidents(Boolean.valueOf(true));
            queryDto.incidentStatus(HistoricProcessInstanceQueryDto.IncidentStatusEnum.OPEN);
        });
        QueryUtils.addIfNotNull((Object)filter.getStartTimeAfter(), arg_0 -> ((HistoricProcessInstanceQueryDto)queryDto).startedAfter(arg_0));
        QueryUtils.addIfNotNull((Object)filter.getStartTimeBefore(), arg_0 -> ((HistoricProcessInstanceQueryDto)queryDto).startedBefore(arg_0));
        QueryUtils.addIfNotNull((Object)filter.getEndTimeAfter(), arg_0 -> ((HistoricProcessInstanceQueryDto)queryDto).finishedAfter(arg_0));
        QueryUtils.addIfNotNull((Object)filter.getEndTimeBefore(), arg_0 -> ((HistoricProcessInstanceQueryDto)queryDto).finishedBefore(arg_0));
        QueryUtils.addIfNotNull((Object)filter.getActiveActivityIdIn(), arg_0 -> ((HistoricProcessInstanceQueryDto)queryDto).activeActivityIdIn(arg_0));
    }

    public static void addHistorySort(HistoricProcessInstanceQueryDto queryDto, @Nullable Sort sort) {
        if (sort != null) {
            ArrayList<HistoricProcessInstanceQueryDtoSortingInner> sortOptions = new ArrayList<HistoricProcessInstanceQueryDtoSortingInner>();
            for (Sort.Order order : sort.getOrders()) {
                HistoricProcessInstanceQueryDtoSortingInner.SortByEnum sortBy = switch (order.getProperty()) {
                    case "id" -> HistoricProcessInstanceQueryDtoSortingInner.SortByEnum.INSTANCE_ID;
                    case "processDefinitionId" -> HistoricProcessInstanceQueryDtoSortingInner.SortByEnum.DEFINITION_ID;
                    case "processDefinitionKey" -> HistoricProcessInstanceQueryDtoSortingInner.SortByEnum.DEFINITION_KEY;
                    case "businessKey" -> HistoricProcessInstanceQueryDtoSortingInner.SortByEnum.BUSINESS_KEY;
                    case "startTime" -> HistoricProcessInstanceQueryDtoSortingInner.SortByEnum.START_TIME;
                    case "endTime" -> HistoricProcessInstanceQueryDtoSortingInner.SortByEnum.END_TIME;
                    default -> null;
                };
                HistoricProcessInstanceQueryDtoSortingInner.SortOrderEnum sortOrder = null;
                Sort.Direction direction = order.getDirection();
                if (direction == Sort.Direction.ASC) {
                    sortOrder = HistoricProcessInstanceQueryDtoSortingInner.SortOrderEnum.ASC;
                } else if (direction == Sort.Direction.DESC) {
                    sortOrder = HistoricProcessInstanceQueryDtoSortingInner.SortOrderEnum.DESC;
                }
                if (sortBy == null || sortOrder == null) continue;
                sortOptions.add(new HistoricProcessInstanceQueryDtoSortingInner().sortBy(sortBy).sortOrder(sortOrder));
            }
            queryDto.setSorting(sortOptions);
        }
    }

    public static void addDefinitionFilters(ProcessDefinitionQuery processDefinitionQuery, @Nullable ProcessDefinitionFilter filter) {
        if (filter == null) {
            return;
        }
        QueryUtils.wrapAndAddStringIfNotEmpty((String)filter.getKeyLike(), arg_0 -> ((ProcessDefinitionQuery)processDefinitionQuery).processDefinitionKeyLike(arg_0));
        QueryUtils.wrapAndAddStringIfNotEmpty((String)filter.getNameLike(), arg_0 -> ((ProcessDefinitionQuery)processDefinitionQuery).processDefinitionNameLike(arg_0));
        QueryUtils.addIfStringNotEmpty((String)filter.getKey(), arg_0 -> ((ProcessDefinitionQuery)processDefinitionQuery).processDefinitionKey(arg_0));
        QueryUtils.addIfStringNotEmpty((String)filter.getVersionTag(), arg_0 -> ((ProcessDefinitionQuery)processDefinitionQuery).versionTag(arg_0));
        QueryUtils.addIfNotNull((Object)filter.getVersion(), arg_0 -> ((ProcessDefinitionQuery)processDefinitionQuery).processDefinitionVersion(arg_0));
        QueryUtils.addCollectionIfNotEmpty((Collection)filter.getKeyIn(), (T xva$0) -> processDefinitionQuery.processDefinitionKeyIn(new String[]{xva$0}));
        QueryUtils.addCollectionIfNotEmpty((Collection)filter.getIdIn(), (T xva$0) -> processDefinitionQuery.processDefinitionIdIn(new String[]{xva$0}));
        QueryUtils.addIfTrue((Boolean)filter.getLatestVersionOnly(), () -> ((ProcessDefinitionQuery)processDefinitionQuery).latestVersion());
        QueryUtils.addIfStringNotEmpty((String)filter.getDeploymentId(), arg_0 -> ((ProcessDefinitionQuery)processDefinitionQuery).deploymentId(arg_0));
        QueryUtils.addIfTrue((Boolean)(filter.getState() == ProcessDefinitionState.ACTIVE ? 1 : 0), () -> ((ProcessDefinitionQuery)processDefinitionQuery).active());
        QueryUtils.addIfTrue((Boolean)(filter.getState() == ProcessDefinitionState.SUSPENDED ? 1 : 0), () -> ((ProcessDefinitionQuery)processDefinitionQuery).suspended());
    }

    public static void addDeploymentFilters(DeploymentQuery deploymentQuery, @Nullable DeploymentFilter filter) {
        if (filter == null) {
            return;
        }
        QueryUtils.addIfStringNotEmpty((String)filter.getDeploymentId(), arg_0 -> ((DeploymentQuery)deploymentQuery).deploymentId(arg_0));
        QueryUtils.wrapAndAddStringIfNotEmpty((String)filter.getNameLike(), arg_0 -> ((DeploymentQuery)deploymentQuery).deploymentNameLike(arg_0));
        QueryUtils.addIfStringNotEmpty((String)filter.getSource(), arg_0 -> ((DeploymentQuery)deploymentQuery).deploymentSource(arg_0));
        QueryUtils.addCollectionIfNotEmpty((Collection)filter.getTenantIdIn(), (T xva$0) -> deploymentQuery.tenantIdIn(new String[]{xva$0}));
        QueryUtils.addIfTrue((Boolean)filter.getWithoutTenantId(), () -> ((DeploymentQuery)deploymentQuery).withoutTenantId());
        if (filter.getDeploymentAfter() != null) {
            deploymentQuery.deploymentAfter(Date.from(filter.getDeploymentAfter().toInstant()));
        }
        if (filter.getDeploymentBefore() != null) {
            deploymentQuery.deploymentBefore(Date.from(filter.getDeploymentBefore().toInstant()));
        }
    }

    public static void addDecisionDefinitionFilters(DecisionDefinitionQuery decisionDefinitionQuery, @Nullable DecisionDefinitionFilter filter) {
        if (filter == null) {
            return;
        }
        QueryUtils.wrapAndAddStringIfNotEmpty((String)filter.getKeyLike(), arg_0 -> ((DecisionDefinitionQuery)decisionDefinitionQuery).decisionDefinitionKeyLike(arg_0));
        QueryUtils.wrapAndAddStringIfNotEmpty((String)filter.getNameLike(), arg_0 -> ((DecisionDefinitionQuery)decisionDefinitionQuery).decisionDefinitionNameLike(arg_0));
        QueryUtils.addIfStringNotEmpty((String)filter.getKey(), arg_0 -> ((DecisionDefinitionQuery)decisionDefinitionQuery).decisionDefinitionKey(arg_0));
        QueryUtils.addCollectionIfNotEmpty((Collection)filter.getIdIn(), (T xva$0) -> decisionDefinitionQuery.decisionDefinitionIdIn(new String[]{xva$0}));
        QueryUtils.addIfTrue((Boolean)filter.getLatestVersionOnly(), () -> ((DecisionDefinitionQuery)decisionDefinitionQuery).latestVersion());
    }

    public static void addDecisionInstanceFilters(HistoricDecisionInstanceQuery decisionInstanceQuery, @Nullable DecisionInstanceFilter filter) {
        if (filter == null) {
            return;
        }
        QueryUtils.addIfStringNotEmpty((String)filter.getDecisionDefinitionId(), arg_0 -> ((HistoricDecisionInstanceQuery)decisionInstanceQuery).decisionDefinitionId(arg_0));
        QueryUtils.addIfStringNotEmpty((String)filter.getProcessDefinitionKey(), arg_0 -> ((HistoricDecisionInstanceQuery)decisionInstanceQuery).processDefinitionKey(arg_0));
        QueryUtils.addIfStringNotEmpty((String)filter.getProcessInstanceId(), arg_0 -> ((HistoricDecisionInstanceQuery)decisionInstanceQuery).processInstanceId(arg_0));
        QueryUtils.addIfStringNotEmpty((String)filter.getActivityId(), (T xva$0) -> decisionInstanceQuery.activityIdIn(new String[]{xva$0}));
        if (filter.getEvaluatedAfter() != null) {
            decisionInstanceQuery.evaluatedAfter(Date.from(filter.getEvaluatedAfter().toInstant()));
        }
        if (filter.getEvaluatedBefore() != null) {
            decisionInstanceQuery.evaluatedBefore(Date.from(filter.getEvaluatedBefore().toInstant()));
        }
    }

    public static void addDefinitionSort(ProcessDefinitionQuery processDefinitionQuery, @Nullable Sort sort) {
        if (sort != null) {
            for (Sort.Order order : sort.getOrders()) {
                boolean unknownValueUsed = false;
                switch (order.getProperty()) {
                    case "name": {
                        processDefinitionQuery.orderByProcessDefinitionName();
                        break;
                    }
                    case "key": {
                        processDefinitionQuery.orderByProcessDefinitionKey();
                        break;
                    }
                    case "version": {
                        processDefinitionQuery.orderByProcessDefinitionVersion();
                        break;
                    }
                    default: {
                        unknownValueUsed = true;
                    }
                }
                QueryUtils.addSortDirection((Query)processDefinitionQuery, (!unknownValueUsed ? 1 : 0) != 0, (Sort.Order)order);
            }
        }
    }

    public static void addDeploymentSort(DeploymentQuery deploymentQuery, @Nullable Sort sort) {
        if (sort != null) {
            for (Sort.Order order : sort.getOrders()) {
                boolean unknownValueUsed = false;
                switch (order.getProperty()) {
                    case "id": {
                        deploymentQuery.orderByDeploymentId();
                        break;
                    }
                    case "name": {
                        deploymentQuery.orderByDeploymentName();
                        break;
                    }
                    case "time": {
                        deploymentQuery.orderByDeploymentTime();
                        break;
                    }
                    case "tenantId": {
                        deploymentQuery.orderByTenantId();
                        break;
                    }
                    default: {
                        unknownValueUsed = true;
                    }
                }
                QueryUtils.addSortDirection((Query)deploymentQuery, (!unknownValueUsed ? 1 : 0) != 0, (Sort.Order)order);
            }
        }
    }

    public static void addDecisionDefinitionSort(DecisionDefinitionQuery processDefinitionQuery, @Nullable Sort sort) {
        if (sort != null) {
            for (Sort.Order order : sort.getOrders()) {
                boolean unknownValueUsed = false;
                switch (order.getProperty()) {
                    case "name": {
                        processDefinitionQuery.orderByDecisionDefinitionName();
                        break;
                    }
                    case "key": {
                        processDefinitionQuery.orderByDecisionDefinitionKey();
                        break;
                    }
                    case "version": {
                        processDefinitionQuery.orderByDecisionDefinitionVersion();
                        break;
                    }
                    default: {
                        unknownValueUsed = true;
                    }
                }
                QueryUtils.addSortDirection((Query)processDefinitionQuery, (!unknownValueUsed ? 1 : 0) != 0, (Sort.Order)order);
            }
        }
    }

    public static void addDecisionInstanceSort(HistoricDecisionInstanceQuery decisionInstanceQuery, @Nullable Sort sort) {
        if (sort != null) {
            for (Sort.Order order : sort.getOrders()) {
                boolean unknownValueUsed = false;
                switch (order.getProperty()) {
                    case "evaluationTime": {
                        decisionInstanceQuery.orderByEvaluationTime();
                        break;
                    }
                    case "tenantId": {
                        decisionInstanceQuery.orderByEvaluationTime();
                        break;
                    }
                    default: {
                        unknownValueUsed = true;
                    }
                }
                QueryUtils.addSortDirection((Query)decisionInstanceQuery, (!unknownValueUsed ? 1 : 0) != 0, (Sort.Order)order);
            }
        }
    }

    public static void addIfStringNotEmpty(String filterValue, Consumer<String> filterValueConsumer) {
        if (StringUtils.hasText((String)filterValue)) {
            filterValueConsumer.accept(filterValue);
        }
    }

    public static void wrapAndAddStringIfNotEmpty(String filterValue, Consumer<String> filterValueConsumer) {
        if (StringUtils.hasText((String)filterValue)) {
            filterValueConsumer.accept("%" + filterValue + "%");
        }
    }

    public static void addIfTrue(Boolean filterValue, Runnable filterValueConsumer) {
        if (BooleanUtils.isTrue((Boolean)filterValue)) {
            filterValueConsumer.run();
        }
    }

    public static <V> void addIfNotNull(V filterValue, Consumer<V> filterValueConsumer) {
        if (filterValue != null) {
            filterValueConsumer.accept(filterValue);
        }
    }

    public static void addCollectionIfNotEmpty(Collection<String> filterValues, Consumer<String> filterValueConsumer) {
        if (CollectionUtils.isNotEmpty(filterValues)) {
            filterValueConsumer.accept(String.join((CharSequence)",", filterValues));
        }
    }

    public static void addSortDirection(Query<?, ?> query, boolean propertyIsSet, Sort.Order order) {
        if (!propertyIsSet) {
            return;
        }
        Sort.Direction direction = order.getDirection();
        if (direction == Sort.Direction.ASC) {
            query.asc();
        } else if (direction == Sort.Direction.DESC) {
            query.desc();
        }
    }
}

