/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.service.processinstance.impl;

import feign.FeignException;
import feign.utils.ExceptionUtils;
import io.flowset.control.entity.filter.ProcessInstanceFilter;
import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.entity.processinstance.RuntimeProcessInstanceData;
import io.flowset.control.entity.variable.VariableInstanceData;
import io.flowset.control.exception.EngineNotSelectedException;
import io.flowset.control.mapper.ProcessInstanceMapper;
import io.flowset.control.service.processinstance.ProcessInstanceLoadContext;
import io.flowset.control.service.processinstance.ProcessInstanceService;
import io.flowset.control.service.variable.VariableUtils;
import io.flowset.control.util.EngineRestUtils;
import io.flowset.control.util.QueryUtils;
import io.jmix.core.Sort;
import java.net.ConnectException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.community.rest.client.api.HistoryApiClient;
import org.camunda.community.rest.client.api.ProcessInstanceApiClient;
import org.camunda.community.rest.client.model.CountResultDto;
import org.camunda.community.rest.client.model.HistoricProcessInstanceDto;
import org.camunda.community.rest.client.model.HistoricProcessInstanceQueryDto;
import org.camunda.community.rest.client.model.ProcessInstanceSuspensionStateAsyncDto;
import org.camunda.community.rest.impl.RemoteHistoryService;
import org.camunda.community.rest.impl.RemoteRuntimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service(value="control_ProcessInstanceService")
public class ProcessInstanceServiceImpl
implements ProcessInstanceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessInstanceServiceImpl.class);
    protected final RemoteRuntimeService remoteRuntimeService;
    protected final RemoteHistoryService historyService;
    protected final ProcessInstanceApiClient processInstanceApiClient;
    protected final HistoryApiClient historyApiClient;
    protected final ProcessInstanceMapper processInstanceMapper;

    public ProcessInstanceServiceImpl(RemoteRuntimeService remoteRuntimeService, RemoteHistoryService historyService, ProcessInstanceApiClient processInstanceApiClient, HistoryApiClient historyApiClient, ProcessInstanceMapper processInstanceMapper) {
        this.remoteRuntimeService = remoteRuntimeService;
        this.historyService = historyService;
        this.processInstanceApiClient = processInstanceApiClient;
        this.historyApiClient = historyApiClient;
        this.processInstanceMapper = processInstanceMapper;
    }

    public List<ProcessInstanceData> findAllHistoricInstances(ProcessInstanceLoadContext context) {
        try {
            HistoricProcessInstanceQueryDto queryDto = this.createHistoryProcessInstanceQueryDto((ProcessInstanceFilter)context.getFilter(), context.getSort());
            ResponseEntity responseEntity = this.historyApiClient.queryHistoricProcessInstances(context.getFirstResult(), context.getMaxResults(), queryDto);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                List processInstances = Optional.ofNullable((List)responseEntity.getBody()).orElse(List.of());
                List instancesWithIncidents = context.isLoadIncidents() ? this.findRunningInstancesWithIncidents(processInstances) : List.of();
                return processInstances.stream().map(source -> {
                    ProcessInstanceData processInstanceData = this.processInstanceMapper.fromHistoryProcessInstanceDto(source);
                    processInstanceData.setHasIncidents(Boolean.valueOf(instancesWithIncidents.contains(source.getId())));
                    return processInstanceData;
                }).toList();
            }
            log.error("Unable to load historic process instances, status code: {}", (Object)responseEntity.getStatusCode());
            return List.of();
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load historic process instances because BPM engine not selected");
                return List.of();
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable to load historic process instances because of connection error: ", (Throwable)e);
                return List.of();
            }
            throw e;
        }
    }

    public List<RuntimeProcessInstanceData> findAllRuntimeInstances(ProcessInstanceLoadContext loadContext) {
        try {
            ProcessInstanceQuery processInstanceQuery = this.remoteRuntimeService.createProcessInstanceQuery();
            QueryUtils.addRuntimeFilters((ProcessInstanceQuery)processInstanceQuery, (ProcessInstanceFilter)((ProcessInstanceFilter)loadContext.getFilter()));
            QueryUtils.addRuntimeSort((ProcessInstanceQuery)processInstanceQuery, (Sort)loadContext.getSort());
            List processInstances = loadContext.getFirstResult() != null && loadContext.getMaxResults() != null ? processInstanceQuery.listPage(loadContext.getFirstResult().intValue(), loadContext.getMaxResults().intValue()) : processInstanceQuery.list();
            List instancesWithIncidents = loadContext.isLoadIncidents() ? this.findRuntimeInstancesWithIncidents(processInstances) : List.of();
            return processInstances.stream().map(source -> {
                RuntimeProcessInstanceData processInstanceData = this.processInstanceMapper.toRuntimeProcessInstanceData(source);
                processInstanceData.setHasIncidents(Boolean.valueOf(instancesWithIncidents.contains(source.getId())));
                return processInstanceData;
            }).toList();
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load runtime process instances because BPM engine not selected");
                return List.of();
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable to load runtime process instances because of connection error: ", (Throwable)e);
                return List.of();
            }
            throw e;
        }
    }

    public long getHistoricInstancesCount(ProcessInstanceFilter filter) {
        HistoricProcessInstanceQueryDto queryDto = this.createHistoryProcessInstanceQueryDto(filter, null);
        try {
            ResponseEntity responseEntity = this.historyApiClient.queryHistoricProcessInstancesCount(queryDto);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return EngineRestUtils.getCountResult((CountResultDto)((CountResultDto)responseEntity.getBody()));
            }
            log.warn("Unable to load historic process instances count, status code: '{}'", (Object)responseEntity.getStatusCode().value());
            return 0L;
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load historic process instances count because BPM engine not selected");
                return 0L;
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable to load historic process instances count because of connection error: ", (Throwable)e);
                return 0L;
            }
            throw e;
        }
    }

    public long getRuntimeInstancesCount(ProcessInstanceFilter filter) {
        try {
            ProcessInstanceQuery processInstanceQuery = this.remoteRuntimeService.createProcessInstanceQuery();
            QueryUtils.addRuntimeFilters((ProcessInstanceQuery)processInstanceQuery, (ProcessInstanceFilter)filter);
            return processInstanceQuery.count();
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load runtime process instances count because BPM engine not selected");
                return 0L;
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable to load runtime process instances count because of connection error: ", (Throwable)e);
                return 0L;
            }
            throw e;
        }
    }

    public ProcessInstanceData getProcessInstanceById(String processInstanceId) {
        try {
            ResponseEntity responseEntity = this.historyApiClient.getHistoricProcessInstance(processInstanceId);
            if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.hasBody()) {
                return this.processInstanceMapper.fromHistoryProcessInstanceDto((HistoricProcessInstanceDto)responseEntity.getBody());
            }
            log.warn("Unable to load historic process instance by id '{}', status code: '{}'", (Object)processInstanceId, (Object)responseEntity.getStatusCode().value());
            return null;
        }
        catch (Exception e) {
            FeignException feignException;
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load process instance by id '{}' because BPM engine not selected", (Object)processInstanceId);
                return null;
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable to load process instance by id '{}' because of connection error: ", (Object)processInstanceId, (Object)e);
                return null;
            }
            if (rootCause instanceof FeignException && (feignException = (FeignException)rootCause).status() == 404) {
                log.warn("Process instance by id '{}' not found: ", (Object)processInstanceId, (Object)e);
                return null;
            }
            throw e;
        }
    }

    public ProcessInstanceData startProcessByDefinitionId(String processDefinitionId, Collection<VariableInstanceData> variableInstances) {
        try {
            VariableMap variables = VariableUtils.createVariableMap(variableInstances);
            ProcessInstance processInstance = this.remoteRuntimeService.startProcessInstanceById(processDefinitionId, (Map)variables);
            return this.mapFromModelWithDetails(processInstance);
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load start process by definitionId by id '{}' because BPM engine not selected", (Object)processDefinitionId);
                return null;
            }
            throw e;
        }
    }

    public void suspendById(String processInstanceId) {
        try {
            this.remoteRuntimeService.suspendProcessInstanceById(processInstanceId);
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load suspend instance by id '{}' because BPM engine not selected", (Object)processInstanceId);
            }
            throw e;
        }
    }

    public void activateById(String processInstanceId) {
        try {
            this.remoteRuntimeService.activateProcessInstanceById(processInstanceId);
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load activate instance by id '{}' because BPM engine not selected", (Object)processInstanceId);
            }
            throw e;
        }
    }

    public void terminateById(String processInstanceId) {
        try {
            this.remoteRuntimeService.deleteProcessInstance(processInstanceId, null, false, true);
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load terminate instance by id '{}' because BPM engine not selected", (Object)processInstanceId);
            }
            throw e;
        }
    }

    public void terminateByIdsAsync(List<String> processInstanceIds, @Nullable String reason) {
        try {
            this.remoteRuntimeService.deleteProcessInstancesAsync(processInstanceIds, reason);
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load terminate instances by ids '{}' because BPM engine not selected", processInstanceIds);
            }
            throw e;
        }
    }

    public void activateByIdsAsync(List<String> processInstancesIds) {
        try {
            this.processInstanceApiClient.updateSuspensionStateAsyncOperation(new ProcessInstanceSuspensionStateAsyncDto().processInstanceIds(processInstancesIds));
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load activate instances by ids '{}' because BPM engine not selected", processInstancesIds);
            }
            throw e;
        }
    }

    public void suspendByIdsAsync(List<String> processInstancesIds) {
        try {
            this.processInstanceApiClient.updateSuspensionStateAsyncOperation(new ProcessInstanceSuspensionStateAsyncDto().processInstanceIds(processInstancesIds).suspended(Boolean.valueOf(true)));
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load suspend instances by ids '{}' because BPM engine not selected", processInstancesIds);
            }
            throw e;
        }
    }

    public long getCountByProcessDefinitionId(String processDefinitionId) {
        ResponseEntity processInstancesCount = this.processInstanceApiClient.getProcessInstancesCount(null, null, null, null, processDefinitionId, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        if (processInstancesCount.getStatusCode().is2xxSuccessful()) {
            return EngineRestUtils.getCountResult((CountResultDto)((CountResultDto)processInstancesCount.getBody()));
        }
        return -1L;
    }

    public long getCountByDeploymentId(String deploymentId) {
        ResponseEntity processInstancesCount = this.processInstanceApiClient.getProcessInstancesCount(null, null, null, null, null, null, null, null, deploymentId, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        CountResultDto countResultDto = (CountResultDto)processInstancesCount.getBody();
        if (processInstancesCount.getStatusCode().is2xxSuccessful() && countResultDto != null) {
            return countResultDto.getCount();
        }
        return -1L;
    }

    public long getCountByProcessDefinitionKey(String processDefinitionKey) {
        ResponseEntity processInstancesCount = this.processInstanceApiClient.getProcessInstancesCount(null, null, null, null, null, processDefinitionKey, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        if (processInstancesCount.getStatusCode().is2xxSuccessful()) {
            return EngineRestUtils.getCountResult((CountResultDto)((CountResultDto)processInstancesCount.getBody()));
        }
        return -1L;
    }

    protected HistoricProcessInstanceQueryDto createHistoryProcessInstanceQueryDto(@Nullable ProcessInstanceFilter filter, @Nullable Sort sort) {
        HistoricProcessInstanceQueryDto processInstanceQuery = new HistoricProcessInstanceQueryDto();
        QueryUtils.addHistoryFilters((HistoricProcessInstanceQueryDto)processInstanceQuery, (ProcessInstanceFilter)filter);
        QueryUtils.addHistorySort((HistoricProcessInstanceQueryDto)processInstanceQuery, (Sort)sort);
        return processInstanceQuery;
    }

    protected ProcessInstanceData mapFromModelWithDetails(ProcessInstance responseModel) {
        ProcessInstanceData processInstanceData = this.processInstanceMapper.fromProcessInstanceModel(responseModel);
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(responseModel.getProcessInstanceId()).singleResult();
        if (historicProcessInstance != null) {
            processInstanceData.setEndTime(historicProcessInstance.getEndTime());
            processInstanceData.setStartTime(historicProcessInstance.getStartTime());
            processInstanceData.setProcessDefinitionName(historicProcessInstance.getProcessDefinitionName());
            processInstanceData.setBusinessKey(historicProcessInstance.getBusinessKey());
            processInstanceData.setDeleteReason(historicProcessInstance.getDeleteReason());
            processInstanceData.setProcessDefinitionKey(historicProcessInstance.getProcessDefinitionKey());
            processInstanceData.setProcessDefinitionVersion(historicProcessInstance.getProcessDefinitionVersion());
        }
        return processInstanceData;
    }

    protected List<String> findRunningInstancesWithIncidents(List<HistoricProcessInstanceDto> processInstances) {
        Set activeInstanceIds = processInstances.stream().filter(historicProcessInstance -> historicProcessInstance.getEndTime() == null).map(HistoricProcessInstanceDto::getId).collect(Collectors.toSet());
        return this.loadInstancesWithIncidents(activeInstanceIds);
    }

    protected List<String> findRuntimeInstancesWithIncidents(List<ProcessInstance> processInstances) {
        Set activeInstanceIds = processInstances.stream().map(Execution::getId).collect(Collectors.toSet());
        return this.loadInstancesWithIncidents(activeInstanceIds);
    }

    protected List<String> loadInstancesWithIncidents(Set<String> activeInstanceIds) {
        List instancesWithIncidents = this.remoteRuntimeService.createProcessInstanceQuery().withIncident().processInstanceIds(activeInstanceIds).listPage(0, activeInstanceIds.size());
        return instancesWithIncidents.stream().map(Execution::getId).toList();
    }
}

