/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.service.client;

import com.google.common.base.Strings;
import io.flowset.control.entity.engine.AuthType;
import io.flowset.control.entity.engine.BpmEngine;
import io.flowset.control.entity.variable.VariableInstanceData;
import io.flowset.control.exception.EngineConnectionFailedException;
import io.flowset.control.service.engine.EngineService;
import java.io.File;
import java.util.Collections;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component(value="control_EngineRestClient")
public class EngineRestClient {
    protected static final Logger log = LoggerFactory.getLogger(EngineRestClient.class);
    protected final RestTemplate restTemplate;
    protected final EngineService engineService;

    public EngineRestClient(EngineService engineService) {
        this.engineService = engineService;
        this.restTemplate = new RestTemplate();
    }

    public void updateVariableBinary(VariableInstanceData variableInstanceData, File data) {
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"data", (Object)new FileSystemResource(data));
        body.add((Object)"valueType", (Object)variableInstanceData.getType());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        BpmEngine engine = this.engineService.getSelectedEngine();
        if (engine == null) {
            throw new EngineConnectionFailedException(HttpStatus.SERVICE_UNAVAILABLE.value(), "Server unavailable");
        }
        if (BooleanUtils.isTrue((Boolean)engine.getAuthEnabled())) {
            if (engine.getAuthType() == AuthType.BASIC) {
                headers.setBasicAuth(Strings.nullToEmpty((String)engine.getBasicAuthUsername()), Strings.nullToEmpty((String)engine.getBasicAuthPassword()));
            } else if (engine.getAuthType() == AuthType.HTTP_HEADER) {
                headers.add(engine.getHttpHeaderName(), engine.getHttpHeaderValue());
            }
        }
        HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        String name = variableInstanceData.getName();
        String url = engine.getBaseUrl() + "/process-instance/" + variableInstanceData.getExecutionId() + "/variables/" + name + "/data";
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, Void.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            log.error("Error on update process variable, process id {}, process name {}, status code {}", new Object[]{variableInstanceData.getVariableInstanceId(), name, response.getStatusCode()});
        }
    }

    public ResponseEntity<String> getStacktrace(String jobId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.TEXT_PLAIN));
        BpmEngine engine = this.engineService.getSelectedEngine();
        if (engine == null) {
            throw new EngineConnectionFailedException(HttpStatus.SERVICE_UNAVAILABLE.value(), "Server unavailable");
        }
        if (BooleanUtils.isTrue((Boolean)engine.getAuthEnabled())) {
            if (engine.getAuthType() == AuthType.BASIC) {
                headers.setBasicAuth(Strings.nullToEmpty((String)engine.getBasicAuthUsername()), Strings.nullToEmpty((String)engine.getBasicAuthPassword()));
            } else if (engine.getAuthType() == AuthType.HTTP_HEADER) {
                headers.add(engine.getHttpHeaderName(), engine.getHttpHeaderValue());
            }
        }
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        return this.restTemplate.exchange(engine.getBaseUrl() + "/job/" + jobId + "/stacktrace", HttpMethod.GET, entity, String.class, new Object[0]);
    }

    public ResponseEntity<String> getStacktraceHistoricJobLog(String jobId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Collections.singletonList(MediaType.TEXT_PLAIN));
        BpmEngine engine = this.engineService.getSelectedEngine();
        if (engine == null) {
            throw new EngineConnectionFailedException(HttpStatus.SERVICE_UNAVAILABLE.value(), "Server unavailable");
        }
        if (BooleanUtils.isTrue((Boolean)engine.getAuthEnabled())) {
            if (engine.getAuthType() == AuthType.BASIC) {
                headers.setBasicAuth(Strings.nullToEmpty((String)engine.getBasicAuthUsername()), Strings.nullToEmpty((String)engine.getBasicAuthPassword()));
            } else if (engine.getAuthType() == AuthType.HTTP_HEADER) {
                headers.add(engine.getHttpHeaderName(), engine.getHttpHeaderValue());
            }
        }
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        return this.restTemplate.exchange(engine.getBaseUrl() + "/history/job/" + jobId + "/stacktrace", HttpMethod.GET, entity, String.class, new Object[0]);
    }
}

