/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.service.activity.impl;

import feign.FeignException;
import feign.utils.ExceptionUtils;
import io.flowset.control.entity.activity.ActivityInstanceTreeItem;
import io.flowset.control.entity.activity.ActivityShortData;
import io.flowset.control.entity.activity.HistoricActivityInstanceData;
import io.flowset.control.entity.activity.ProcessActivityStatistics;
import io.flowset.control.entity.filter.ActivityFilter;
import io.flowset.control.exception.EngineNotSelectedException;
import io.flowset.control.mapper.ActivityMapper;
import io.flowset.control.mapper.HistoryActivityMapper;
import io.flowset.control.service.activity.ActivityLoadContext;
import io.flowset.control.service.activity.ActivityService;
import io.flowset.control.util.EngineRestUtils;
import io.jmix.core.Sort;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.camunda.community.rest.client.api.HistoryApiClient;
import org.camunda.community.rest.client.api.ProcessDefinitionApiClient;
import org.camunda.community.rest.client.api.ProcessInstanceApiClient;
import org.camunda.community.rest.client.model.ActivityInstanceDto;
import org.camunda.community.rest.client.model.CountResultDto;
import org.camunda.community.rest.client.model.HistoricActivityInstanceDto;
import org.camunda.community.rest.client.model.HistoricActivityInstanceQueryDto;
import org.camunda.community.rest.client.model.HistoricActivityInstanceQueryDtoSortingInner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service(value="control_ActivityService")
public class ActivityServiceImpl
implements ActivityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActivityServiceImpl.class);
    protected final HistoryActivityMapper historyActivityMapper;
    protected final HistoryApiClient historyApiClient;
    protected final ActivityMapper activityMapper;
    protected final ProcessInstanceApiClient processInstanceApi;
    protected final ProcessDefinitionApiClient processDefinitionApi;

    public ActivityServiceImpl(HistoryActivityMapper historyActivityMapper, HistoryApiClient historyApiClient, ActivityMapper activityMapper, ProcessInstanceApiClient processInstanceApi, ProcessDefinitionApiClient processDefinitionApi) {
        this.historyActivityMapper = historyActivityMapper;
        this.historyApiClient = historyApiClient;
        this.activityMapper = activityMapper;
        this.processInstanceApi = processInstanceApi;
        this.processDefinitionApi = processDefinitionApi;
    }

    public List<ActivityShortData> findRunningActivities(String processInstanceId) {
        HistoricActivityInstanceQueryDto queryDto = new HistoricActivityInstanceQueryDto().processInstanceId(processInstanceId).unfinished(Boolean.valueOf(true));
        ResponseEntity response = this.historyApiClient.queryHistoricActivityInstances(null, null, queryDto);
        if (response.getStatusCode().is2xxSuccessful()) {
            List activityInstanceDtoList = (List)response.getBody();
            return CollectionUtils.emptyIfNull((Collection)activityInstanceDtoList).stream().map(arg_0 -> ((ActivityMapper)this.activityMapper).fromActivityDto(arg_0)).toList();
        }
        log.error("Error while getting running history activities by process instance id {},  response code {}", (Object)processInstanceId, (Object)response.getStatusCode());
        return List.of();
    }

    public List<ActivityInstanceTreeItem> getActivityInstancesTree(String processInstanceId) {
        ArrayList<ActivityInstanceTreeItem> items = new ArrayList<ActivityInstanceTreeItem>();
        ResponseEntity response = this.processInstanceApi.getActivityInstanceTree(processInstanceId);
        if (response.getStatusCode().is2xxSuccessful() && response.hasBody()) {
            ActivityInstanceDto rootActivityInstance = (ActivityInstanceDto)response.getBody();
            ActivityInstanceTreeItem rootTreeItem = this.cresteActivityInstanceTreeItem(null, rootActivityInstance);
            items.add(rootTreeItem);
            this.addChildItems(rootActivityInstance, rootTreeItem, items);
            this.addTransitionItems(rootActivityInstance, rootTreeItem, items);
        } else {
            log.error("Error while getting activity instances tree by process instance id {},  response code {}", (Object)processInstanceId, (Object)response.getStatusCode());
        }
        return items;
    }

    public List<ActivityShortData> findFinishedActivities(String processInstanceId) {
        HistoricActivityInstanceQueryDto queryDto = new HistoricActivityInstanceQueryDto().processInstanceId(processInstanceId).finished(Boolean.valueOf(true));
        ResponseEntity response = this.historyApiClient.queryHistoricActivityInstances(null, null, queryDto);
        if (response.getStatusCode().is2xxSuccessful()) {
            List historicActivityInstanceDtos = (List)response.getBody();
            return CollectionUtils.emptyIfNull((Collection)historicActivityInstanceDtos).stream().map(arg_0 -> ((ActivityMapper)this.activityMapper).fromActivityDto(arg_0)).toList();
        }
        log.error("Error while getting finished history activities by process instance id {}, response code {}", (Object)processInstanceId, (Object)response.getStatusCode());
        return List.of();
    }

    public List<HistoricActivityInstanceData> findAllHistoryActivities(ActivityLoadContext loadContext) {
        HistoricActivityInstanceQueryDto queryDto = this.createActivityQueryDto((ActivityFilter)loadContext.getFilter());
        this.addSortOptions(loadContext.getSort(), queryDto);
        ResponseEntity response = this.historyApiClient.queryHistoricActivityInstances(loadContext.getFirstResult(), loadContext.getMaxResults(), queryDto);
        if (response.getStatusCode().is2xxSuccessful()) {
            List activityInstanceDtoList = (List)response.getBody();
            return CollectionUtils.emptyIfNull((Collection)activityInstanceDtoList).stream().map(arg_0 -> ((HistoryActivityMapper)this.historyActivityMapper).fromHistoryActivityDto(arg_0)).toList();
        }
        log.error("Error while getting history activities, {}", (Object)response.getStatusCode());
        return List.of();
    }

    public long getHistoryActivitiesCount(@Nullable ActivityFilter filter) {
        HistoricActivityInstanceQueryDto queryDto = this.createActivityQueryDto(filter);
        ResponseEntity response = this.historyApiClient.queryHistoricActivityInstancesCount(queryDto);
        if (response.getStatusCode().is2xxSuccessful()) {
            return EngineRestUtils.getCountResult((CountResultDto)((CountResultDto)response.getBody()));
        }
        log.error("Error while getting history activities count, {}", (Object)response.getStatusCode());
        return 0L;
    }

    @Nullable
    public HistoricActivityInstanceData findById(String activityInstanceId) {
        ResponseEntity response = this.historyApiClient.getHistoricActivityInstance(activityInstanceId);
        if (response.getStatusCode().is2xxSuccessful()) {
            HistoricActivityInstanceDto activityInstanceDto = (HistoricActivityInstanceDto)response.getBody();
            return activityInstanceDto != null ? this.historyActivityMapper.fromHistoryActivityDto(activityInstanceDto) : null;
        }
        log.error("Error while getting history activity by id {}, status code: {}", (Object)activityInstanceId, (Object)response.getStatusCode());
        return null;
    }

    public List<ProcessActivityStatistics> getStatisticsByProcessId(String processDefinitionId) {
        try {
            List statisticsResultDtoList;
            ResponseEntity response = this.processDefinitionApi.getActivityStatistics(processDefinitionId, Boolean.valueOf(true), Boolean.valueOf(true), null);
            if (response.getStatusCode().is2xxSuccessful() && (statisticsResultDtoList = (List)response.getBody()) != null) {
                return statisticsResultDtoList.stream().map(arg_0 -> ((ActivityMapper)this.activityMapper).fromActivityStatisticsResult(arg_0)).toList();
            }
        }
        catch (Exception e) {
            FeignException feignException;
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof EngineNotSelectedException) {
                log.warn("Unable to load process definition activity statistics by id '{}' because BPM engine not selected", (Object)processDefinitionId);
                return null;
            }
            if (rootCause instanceof ConnectException) {
                log.error("Unable load process definition activity statistics by id '{}' because of connection error: ", (Object)processDefinitionId, (Object)e);
                return null;
            }
            if (rootCause instanceof FeignException && (feignException = (FeignException)rootCause).status() == 404) {
                log.warn("Unable to load process definition activity statistics by id '{}' because process does not exist", (Object)processDefinitionId);
                return null;
            }
            throw e;
        }
        return List.of();
    }

    protected HistoricActivityInstanceQueryDto createActivityQueryDto(@Nullable ActivityFilter filter) {
        HistoricActivityInstanceQueryDto queryDto = new HistoricActivityInstanceQueryDto();
        if (filter != null) {
            queryDto.setProcessInstanceId(filter.getProcessInstanceId());
        }
        return queryDto;
    }

    protected void addSortOptions(Sort sort, HistoricActivityInstanceQueryDto queryDto) {
        if (sort != null) {
            ArrayList<HistoricActivityInstanceQueryDtoSortingInner> sortOptions = new ArrayList<HistoricActivityInstanceQueryDtoSortingInner>();
            for (Sort.Order order : sort.getOrders()) {
                HistoricActivityInstanceQueryDtoSortingInner sortOption = new HistoricActivityInstanceQueryDtoSortingInner();
                switch (order.getProperty()) {
                    case "activityId": {
                        sortOption.setSortBy(HistoricActivityInstanceQueryDtoSortingInner.SortByEnum.ACTIVITY_ID);
                        break;
                    }
                    case "activityType": {
                        sortOption.setSortBy(HistoricActivityInstanceQueryDtoSortingInner.SortByEnum.ACTIVITY_TYPE);
                        break;
                    }
                    case "activityName": {
                        sortOption.setSortBy(HistoricActivityInstanceQueryDtoSortingInner.SortByEnum.ACTIVITY_NAME);
                        break;
                    }
                    case "startTime": {
                        sortOption.setSortBy(HistoricActivityInstanceQueryDtoSortingInner.SortByEnum.START_TIME);
                        break;
                    }
                    case "endTime": {
                        sortOption.setSortBy(HistoricActivityInstanceQueryDtoSortingInner.SortByEnum.END_TIME);
                        break;
                    }
                }
                if (order.getDirection() == Sort.Direction.ASC) {
                    sortOption.setSortOrder(HistoricActivityInstanceQueryDtoSortingInner.SortOrderEnum.ASC);
                } else if (order.getDirection() == Sort.Direction.DESC) {
                    sortOption.setSortOrder(HistoricActivityInstanceQueryDtoSortingInner.SortOrderEnum.DESC);
                }
                if (sortOption.getSortBy() == null || sortOption.getSortOrder() == null) continue;
                sortOptions.add(sortOption);
            }
            queryDto.setSorting(sortOptions);
        }
    }

    protected void addChildItems(ActivityInstanceDto rootItem, ActivityInstanceTreeItem parentItem, List<ActivityInstanceTreeItem> resultItems) {
        if (rootItem == null || CollectionUtils.isEmpty((Collection)rootItem.getChildActivityInstances())) {
            return;
        }
        rootItem.getChildActivityInstances().forEach(activityInstanceDto -> {
            ActivityInstanceTreeItem activityInstanceTreeItem = this.cresteActivityInstanceTreeItem(parentItem, activityInstanceDto);
            resultItems.add(activityInstanceTreeItem);
            this.addChildItems(activityInstanceDto, activityInstanceTreeItem, resultItems);
            this.addTransitionItems(activityInstanceDto, activityInstanceTreeItem, resultItems);
        });
    }

    protected ActivityInstanceTreeItem cresteActivityInstanceTreeItem(@Nullable ActivityInstanceTreeItem treeItem, ActivityInstanceDto activityInstanceDto) {
        ActivityInstanceTreeItem activityInstanceTreeItem = this.activityMapper.fromRuntimeActivityDto(activityInstanceDto);
        activityInstanceTreeItem.setParentActivityInstance(treeItem);
        return activityInstanceTreeItem;
    }

    protected void addTransitionItems(ActivityInstanceDto rootItem, ActivityInstanceTreeItem treeItem, List<ActivityInstanceTreeItem> resultItems) {
        if (rootItem == null || CollectionUtils.isEmpty((Collection)rootItem.getChildTransitionInstances())) {
            return;
        }
        rootItem.getChildTransitionInstances().forEach(transitionInstanceDto -> {
            ActivityInstanceTreeItem activityInstanceTreeItem = this.activityMapper.fromRuntimeTransitionDto(transitionInstanceDto);
            activityInstanceTreeItem.setParentActivityInstance(treeItem);
            resultItems.add(activityInstanceTreeItem);
        });
    }
}

