/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.restsupport;

import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.Request;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import io.flowset.control.restsupport.FeignClientCreationContext;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.springframework.cloud.openfeign.FeignClientProperties;

public class FeignClientProvider {
    protected final Encoder encoder;
    protected final Decoder decoder;
    protected final Retryer retryer;
    protected final ErrorDecoder errorDecoder;
    protected final Contract contract;
    protected final Client client;
    protected final FeignClientProperties feignClientProperties;

    public FeignClientProvider(Encoder encoder, Decoder decoder, Retryer retryer, ErrorDecoder errorDecoder, Contract contract, Client client, FeignClientProperties feignClientProperties) {
        this.encoder = encoder;
        this.decoder = decoder;
        this.retryer = retryer;
        this.errorDecoder = errorDecoder;
        this.contract = contract;
        this.client = client;
        this.feignClientProperties = feignClientProperties;
    }

    public <V> V createCamundaClient(FeignClientCreationContext<V> context) {
        Feign.Builder builder = Feign.builder().contract(this.contract).encoder(this.encoder).decoder(this.decoder).errorDecoder(this.errorDecoder);
        FeignClientProperties.FeignClientConfiguration defaultConfig = (FeignClientProperties.FeignClientConfiguration)this.feignClientProperties.getConfig().get(this.feignClientProperties.getDefaultConfig());
        this.applyIfNotNull((Object)this.client, arg_0 -> ((Feign.Builder)builder).client(arg_0));
        this.addLoggerLevel(builder, defaultConfig);
        this.applyIfNotNull((Object)context.getRequestInterceptor(), arg_0 -> ((Feign.Builder)builder).requestInterceptor(arg_0));
        this.setRetryer(context, builder);
        this.setConnectTimeouts(context, builder, defaultConfig);
        Class clientClass = context.getClientClass();
        String url = context.getUrl();
        return (V)(url == null ? builder.target((Target)Target.EmptyTarget.create((Class)clientClass)) : builder.target(clientClass, url));
    }

    protected void addLoggerLevel(Feign.Builder builder, FeignClientProperties.FeignClientConfiguration defaultConfig) {
        if (defaultConfig != null && defaultConfig.getLoggerLevel() != null) {
            builder.logLevel(defaultConfig.getLoggerLevel());
        }
    }

    protected <E> void applyIfNotNull(E value, Function<E, Feign.Builder> feignClientBuilder) {
        if (value != null) {
            feignClientBuilder.apply(value);
        }
    }

    protected <V> void setConnectTimeouts(FeignClientCreationContext<V> context, Feign.Builder builder, FeignClientProperties.FeignClientConfiguration defaultConfig) {
        Integer connectTimeout = context.getConnectTimeout();
        Integer readTimeout = context.getReadTimeout();
        if (connectTimeout == null && readTimeout == null && defaultConfig != null) {
            connectTimeout = defaultConfig.getConnectTimeout();
            readTimeout = defaultConfig.getReadTimeout();
        }
        if (connectTimeout != null && readTimeout != null) {
            builder.options(new Request.Options((long)connectTimeout.intValue(), TimeUnit.MILLISECONDS, (long)readTimeout.intValue(), TimeUnit.MILLISECONDS, false));
        } else {
            builder.options(new Request.Options());
        }
    }

    protected <V> void setRetryer(FeignClientCreationContext<V> context, Feign.Builder builder) {
        Integer retriesTimeout = context.getRetryTimeout();
        Integer maxRetries = context.getMaxRetries();
        if (retriesTimeout != null && maxRetries != null) {
            builder.retryer((Retryer)new Retryer.Default((long)retriesTimeout.intValue(), (long)retriesTimeout.intValue(), maxRetries.intValue()));
        } else {
            builder.retryer(this.retryer);
        }
    }
}

