/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.mapper;

import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.entity.processinstance.RuntimeProcessInstanceData;
import io.flowset.control.mapper.ProcessInstanceMapper;
import io.jmix.core.Metadata;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.Optional;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.community.rest.client.model.HistoricProcessInstanceDto;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.TargetType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;

@Mapper(componentModel="spring")
public abstract class ProcessInstanceMapper {
    @Autowired
    Metadata metadata;

    @Mappings(value={@Mapping(target="hasIncidents", ignore=true), @Mapping(target="instanceId", source="id"), @Mapping(target="complete", constant="false"), @Mapping(target="externallyTerminated", constant="false"), @Mapping(target="internallyTerminated", constant="false"), @Mapping(target="processDefinitionName", ignore=true), @Mapping(target="processDefinitionKey", ignore=true), @Mapping(target="startTime", ignore=true), @Mapping(target="endTime", ignore=true), @Mapping(target="processDefinitionVersion", ignore=true), @Mapping(target="deleteReason", ignore=true)})
    public abstract ProcessInstanceData fromProcessInstanceModel(ProcessInstance var1);

    @Mappings(value={@Mapping(target="hasIncidents", ignore=true), @Mapping(target="instanceId", source="id"), @Mapping(target="complete", ignore=true), @Mapping(target="suspended", ignore=true), @Mapping(target="externallyTerminated", ignore=true), @Mapping(target="internallyTerminated", ignore=true), @Mapping(target="deleteReason", source="deleteReason")})
    public abstract ProcessInstanceData fromHistoryProcessInstanceDto(HistoricProcessInstanceDto var1);

    @Nullable
    protected Date offsetDateTimeToDate(@Nullable OffsetDateTime offsetDateTime) {
        return Optional.ofNullable(offsetDateTime).map(value -> Date.from(value.toInstant())).orElse(null);
    }

    @AfterMapping
    protected void afterHistoricProcessInstanceDtoMapping(@MappingTarget ProcessInstanceData processInstanceData, HistoricProcessInstanceDto sourceDto) {
        HistoricProcessInstanceDto.StateEnum state = sourceDto.getState();
        switch (1.$SwitchMap$org$camunda$community$rest$client$model$HistoricProcessInstanceDto$StateEnum[state.ordinal()]) {
            case 1: {
                processInstanceData.setComplete(Boolean.valueOf(true));
                break;
            }
            case 2: {
                processInstanceData.setSuspended(Boolean.valueOf(true));
                break;
            }
            case 3: {
                processInstanceData.setExternallyTerminated(Boolean.valueOf(true));
                break;
            }
            case 4: {
                processInstanceData.setInternallyTerminated(Boolean.valueOf(true));
                break;
            }
        }
    }

    @Mappings(value={@Mapping(target="hasIncidents", ignore=true), @Mapping(target="instanceId", source="id")})
    public abstract RuntimeProcessInstanceData toRuntimeProcessInstanceData(ProcessInstance var1);

    public <T extends RuntimeProcessInstanceData> T createProcessInstanceData(@TargetType Class<T> processInstanceClass) {
        return (T)((RuntimeProcessInstanceData)this.metadata.create(processInstanceClass));
    }
}

