/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.mapper;

import io.flowset.control.entity.dashboard.IncidentStatistics;
import io.flowset.control.entity.dashboard.ProcessDefinitionStatistics;
import io.flowset.control.entity.processdefinition.ProcessDefinitionData;
import io.flowset.control.mapper.ProcessDefinitionMapper;
import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.community.rest.client.model.IncidentStatisticsResultDto;
import org.camunda.community.rest.client.model.ProcessDefinitionDto;
import org.camunda.community.rest.client.model.ProcessDefinitionStatisticsResultDto;
import org.springframework.stereotype.Component;

@Component
public class ProcessDefinitionMapperImpl
extends ProcessDefinitionMapper {
    public ProcessDefinitionData fromProcessDefinitionModel(ProcessDefinition source) {
        if (source == null) {
            return null;
        }
        ProcessDefinitionData processDefinitionData = this.targetClassFactory();
        processDefinitionData.setProcessDefinitionId(source.getId());
        processDefinitionData.setStartableInTaskList(Boolean.valueOf(source.isStartableInTasklist()));
        processDefinitionData.setId(source.getId());
        processDefinitionData.setVersionTag(source.getVersionTag());
        processDefinitionData.setName(source.getName());
        processDefinitionData.setKey(source.getKey());
        processDefinitionData.setCategory(source.getCategory());
        processDefinitionData.setDeploymentId(source.getDeploymentId());
        processDefinitionData.setHistoryTimeToLive(source.getHistoryTimeToLive());
        processDefinitionData.setResourceName(source.getResourceName());
        processDefinitionData.setDiagramResourceName(source.getDiagramResourceName());
        processDefinitionData.setTenantId(source.getTenantId());
        processDefinitionData.setDescription(source.getDescription());
        processDefinitionData.setVersion(Integer.valueOf(source.getVersion()));
        processDefinitionData.setSuspended(Boolean.valueOf(this.isSuspended(source)));
        return processDefinitionData;
    }

    public ProcessDefinitionStatistics fromStatisticsResultDto(ProcessDefinitionStatisticsResultDto resultDto) {
        if (resultDto == null) {
            return null;
        }
        ProcessDefinitionStatistics processDefinitionStatistics = this.processDefinitionStatisticsClassFactory();
        processDefinitionStatistics.setProcessDefinition(this.fromProcessDefinitionDto(resultDto.getDefinition()));
        processDefinitionStatistics.setProcessDefinitionId(resultDto.getId());
        processDefinitionStatistics.setFailedJobCount(resultDto.getFailedJobs());
        processDefinitionStatistics.setInstanceCount(resultDto.getInstances());
        processDefinitionStatistics.setIncidents(this.incidentStatisticsResultDtoListToIncidentStatisticsList(resultDto.getIncidents()));
        return processDefinitionStatistics;
    }

    public ProcessDefinitionData fromProcessDefinitionDto(ProcessDefinitionDto source) {
        if (source == null) {
            return null;
        }
        ProcessDefinitionData processDefinitionData = this.targetClassFactory();
        processDefinitionData.setResourceName(source.getResource());
        processDefinitionData.setDiagramResourceName(source.getResource());
        processDefinitionData.setProcessDefinitionId(source.getId());
        processDefinitionData.setStartableInTaskList(source.getStartableInTasklist());
        processDefinitionData.setVersionTag(source.getVersionTag());
        processDefinitionData.setName(source.getName());
        processDefinitionData.setKey(source.getKey());
        processDefinitionData.setCategory(source.getCategory());
        processDefinitionData.setDeploymentId(source.getDeploymentId());
        processDefinitionData.setHistoryTimeToLive(source.getHistoryTimeToLive());
        processDefinitionData.setTenantId(source.getTenantId());
        processDefinitionData.setDescription(source.getDescription());
        processDefinitionData.setVersion(source.getVersion());
        return processDefinitionData;
    }

    public IncidentStatistics fromStatisticsResultDto(IncidentStatisticsResultDto resultDto) {
        if (resultDto == null) {
            return null;
        }
        IncidentStatistics incidentStatistics = this.incidentStatisticsClassFactory();
        incidentStatistics.setIncidentCount(resultDto.getIncidentCount());
        incidentStatistics.setIncidentType(resultDto.getIncidentType());
        return incidentStatistics;
    }

    protected List<IncidentStatistics> incidentStatisticsResultDtoListToIncidentStatisticsList(List<IncidentStatisticsResultDto> list) {
        if (list == null) {
            return null;
        }
        ArrayList<IncidentStatistics> list1 = new ArrayList<IncidentStatistics>(list.size());
        for (IncidentStatisticsResultDto incidentStatisticsResultDto : list) {
            list1.add(this.fromStatisticsResultDto(incidentStatisticsResultDto));
        }
        return list1;
    }
}

