/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.action;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import io.jmix.core.Messages;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.action.ActionType;
import io.jmix.flowui.action.TargetAction;
import io.jmix.flowui.kit.action.BaseAction;
import io.jmix.flowui.kit.component.ComponentUtils;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;

@ActionType(value="control_copyComponentValueToClipboard")
public class CopyComponentValueToClipboardAction
extends BaseAction
implements TargetAction<HasValue<?, ?>> {
    public static final String ID = "control_copyComponentValueToClipboard";
    protected Messages messages;
    protected Notifications notifications;
    protected HasValue<?, ?> target;

    public CopyComponentValueToClipboardAction() {
        super(ID);
    }

    public CopyComponentValueToClipboardAction(String id) {
        super(id);
        this.icon = ComponentUtils.convertToIcon((VaadinIcon)VaadinIcon.COPY);
    }

    @Autowired
    public void setMessages(Messages messages) {
        this.messages = messages;
        this.text = messages.getMessage("actions.Copy");
    }

    @Autowired
    public void setNotifications(Notifications notifications) {
        this.notifications = notifications;
    }

    public HasValue<?, ?> getTarget() {
        return this.target;
    }

    public void setTarget(HasValue target) {
        this.target = target;
    }

    public void actionPerform(Component component) {
        if (this.target != null) {
            String valueAsString = this.target.isEmpty() ? "" : this.target.getValue().toString();
            Element componentElement = component.getElement();
            componentElement.executeJs("  const textarea = document.createElement(\"textarea\");\n  textarea.value = $0;\n\n  textarea.style.position = \"absolute\";\n  textarea.style.opacity = \"0\";\n\n  document.body.appendChild(textarea);\n  textarea.select();\n  document.execCommand(\"copy\");\n  document.body.removeChild(textarea);\n", new Serializable[]{valueAsString}).then((SerializableConsumer & Serializable)successResult -> this.notifications.create(this.messages.getMessage(this.getClass(), "copyComponentValueAction.copied")).withPosition(Notification.Position.TOP_END).withThemeVariant(NotificationVariant.LUMO_SUCCESS).show(), (SerializableConsumer & Serializable)errorResult -> this.notifications.create(this.messages.getMessage(this.getClass(), "copyComponentValueAction.copyFailed")).withPosition(Notification.Position.TOP_END).withThemeVariant(NotificationVariant.LUMO_ERROR).show());
            UI.getCurrent().getPage().executeJs("window.copyToClipboard($0)", new Serializable[]{valueAsString});
        } else {
            this.notifications.show(this.messages.formatMessage(this.getClass(), "copyComponentValueAction.errorMessage", new Object[]{component.getClassName()}));
        }
    }
}

